program Delphi_test;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  Windows,
  ST_function in 'ST_function.pas';

var
  Dev: Longword;
  DVS: TUSMC_Devices;
  StandaClass: TStandaClass;
  SMPower:boolean = FALSE;

procedure Cls;
var
  buffer: TConsoleScreenBufferInfo;
  i: integer;
begin
  GetConsoleScreenBufferInfo(GetStdHandle(STD_OUTPUT_HANDLE),buffer);
  for i:=0 to buffer.dwSize.y do writeln;
end;

// Function that prints information about connected devices to console
procedure PrintDevices(DVS: TUSMC_Devices);
var
  i: integer;
  Serial,Version:array of PChar;
begin
  Serial:=DVS.Serial;
  SetLength(Serial,DVS.NOD);
  Version:=DVS.Version;
  SetLength(Version,DVS.NOD);
  for i:=0 to DVS.NOD-1 do
  begin
    writeln( Format('Device - %d,'+#9+'Serial Number - %.16s,'+#9+'Version - %.4s', [i+1, Serial[i], Version[i]] ));
  end;
end;

// Function that prints last error information
procedure PrintError;
var
  err: array[0..100] of Char;
	p_err: PChar;
begin
  err:='';
  p_err:=err;
	StandaClass.USMC_GetLastErr(p_err,100);
	writeln('');
	write(p_err);
end;

// Function that prints information about device state to console
procedure PrintDState(const State: TUSMC_State);
var
s,ss: string;
begin
	writeln( 'The state is:' );
	writeln( Format('- Current Position in microsteps - %d', [State.CurPos] ));
	writeln( Format('- Temperature - %.2f'+#248+#67, [State.Temp] ));
	writeln( Format('- Step Divisor - %d', [State.SDivisor]));
  if (State.Loft) then s:='Indefinite' else s:='Fixed';
	writeln( Format('- Loft State - %s', [s] ));
  if (State.Power) then
  begin
   if (State.FullPower) then s:='Full' else s:='Half';
  end
  else s:='Off';
	writeln( Format( '- Power - %s', [s] ));
	if State.RUN then
  begin
    if State.CW_CCW then s:='CCW' else s:='CW';
    if ((State.SDivisor=1) and State.FullSpeed) then ss:='at Full Speed' else ss:='';
		writeln( Format('- Step Motor is Running in %s Direction %s', [s,ss]));
  end
	else writeln( '- Step Motor is Not Running' );
  if State.AReset then s:='is After Reset' else s:='Position Already Set';
	writeln( Format('- Device %s', [s]));
  if State.SyncIN then s:='TRUE' else s:='FALSE';
	writeln( Format('- Input Synchronization Logical Pin State - %s', [s]));
  if State.SyncOUT then s:='TRUE' else s:='FALSE';
	writeln( Format('- Output Synchronization Logical Pin State - %s', [s]));
  if State.RotTr then s:='TRUE' else s:='FALSE';
	writeln( Format('- Rotary Transducer Logical Pin State - %s', [s]));
  if State.RotTrErr then s:='Error' else s:='Clear';
	writeln( Format('- Rotary Transducer Error Flag - %s', [s]));
  if State.EmReset then s:='Pushed' else s:='Unpushed';
	writeln( Format('- Emergency Disable Button - %s', [s]));
  if State.Trailer1 then s:='Pushed' else s:='Unpushed';
	writeln( Format('- Trailer 1 Press State - %s', [s]));
  if State.Trailer2 then s:='Pushed' else s:='Unpushed';
	writeln( Format('- Trailer 2 Press State - %s', [s]));
  if State.Voltage = 0.0 then
		writeln( '- Input Voltage - Low' )
	else
		writeln( Format('- Input Voltage - %.1fV', [State.Voltage]));

end;

// Function that scans start parameters
procedure ScanDStartParameters(var DPos: integer; var Speed:single; var SP: TUSMC_StartParameters);
var
  s:string;
begin
	// Defaults
	Speed:= 2000.0;
	DPos:= 0;
	SP.SDivisor:= 8;

	write( 'Destination position:' );
	readln(s);
  DPos:= StrToIntDef(s,DPos);
	write( 'Speed (in tacts):' );
	readln(s);
  Speed:= StrToFloatDef(s,Speed);
	write( 'Steps Divisor:' );
	readln(s);
	SP.SDivisor:= StrToIntDef(s,SP.SDivisor);
end;

// Function that prints information about device start parameters to console
procedure PrintDStartParameters(DPos:integer; Speed:single; const SP:TUSMC_StartParameters);
var
  s:string;
begin
	writeln( Format('Destination position - %d', [DPos]));
	writeln( Format('Speed - %.2f tacts/s', [Speed] ));
	writeln( Format('Steps Divisor - %d', [SP.SDivisor] ));
	if SP.SDivisor = 1 then
	begin
    if SP.SlStart then s:='Enabled' else s:='Disabled';
		writeln( Format( 'Slow start/stop mode - %s', [s] ));
  end
	else if SP.LoftEn then
	      begin
		      writeln('Automatic backlash operation - Enabled' );
          if SP.DefDir then s:='CCW' else s:='CW';
		      writeln(Format('Automatic backlash operation direction - %s', [s]));

          if SP.ForceLoft then s:='TRUE' else s:='FALSE';
		      writeln(Format('Force automatic backlash operation - %s', [s]));
        end
       else
        begin
		     writeln('Automatic backlash operation - Disabled');
	      end;
	if SP.WSyncIN then
		writeln('Controller will wait for input synchronization signal to start' )
	else
		writeln('Input synchronization signal ignored' );
  if SP.SyncOUTR then s:='' else s:='not ';
  writeln(Format('Output synchronization counter will %sbe reset', [s]));
end;

// Function that prints information about device "mode" parameters to console
procedure PrintDMode(const Mode:TUSMC_Mode);
var
  s:string;
begin
	writeln('Mode parameters:' );
  write('Buttons - ');
	if Mode.PMode then
    writeln('Disabled')
	else
  begin
    writeln('Enabled');
    if Mode.Butt1T then s:='+3/+5 V' else s:='0 V(GND)';
		writeln('Button 1 TRUE state - '+s);
    if Mode.Butt2T then s:='+3/+5 V' else s:='0 V(GND)';
		writeln('Button 2 TRUE state - '+s);
	end;
  if Mode.PReg then s:='Used' else s:='Not Used';
	writeln('Current reduction regime - '+s);

	if Mode.ResetD then
  begin
    if Mode.EMReset then s:='Emerjency Off' else s:='Off';
	  writeln('Power - '+s);
  end
	else
		writeln('Power - On' );

	if (Mode.Tr1En or Mode.Tr2En) then
  begin
    if Mode.TrSwap then s:='Swapped' else s:='Direct';
		writeln('Trailers are - '+s);
  end;

	write( 'Trailer 1 - ');
	if Mode.Tr1En then
  begin
    if Mode.Tr1T then s:='+3/+5 V' else s:='0 V(GND)';
		writeln('Enabled');
    writeln('Trailer 1 TRUE state - '+s);
  end
	else
		writeln('Disabled');

	write( 'Trailer 2 - ');
	if Mode.Tr2En then
  begin
    if Mode.Tr2T then s:='+3/+5 V' else s:='0 V(GND)';
		writeln('Enabled');
    writeln('Trailer 2 TRUE state - '+s);
  end
	else
		writeln('Disabled');

	if Mode.EncoderEn then
  begin
  	writeln( 'Encoder - Enabled');
    if Mode.EncoderInv then s:='Inverted' else s:='Direct';
    writeln( Format('Encoder Position Counter is %s', [s]));
		writeln( 'Rotary Transducer and Input Syncronisation are');
		writeln( 'Disabled Because of Encoder');
  end
	else
  begin
		writeln( 'Encoder - Disabled');
    write( 'Rotary Transducer - ');
    if Mode.RotTeEn then
	  begin
      writeln('Enabled');
		  if Mode.RotTrT then s:='+3/+5 V' else s:='0 V(GND)';
      writeln('Rotary Transducer TRUE state - '+s);
		  if Mode.RotTrOp then s:='Stop on error' else s:='Check and ignore error';
		  writeln('Rotary Transducer Operation - '+s);
      if Mode.ResetRT then s:='Initiated' else s:='No, why?';
		  writeln('Reset Rotary Transducer Check Positions - '+s);
    end
	  else writeln('Disabled');
  	writeln('Synchronization input mode:');
		if Mode.SyncINOp then writeln('Step motor will move one time to the destination position')
		else writeln('Step motor will move multiple times by [destination position]');
	end;

	write( 'Output Syncronization - ');
	if Mode.SyncOUTEn then
	begin
    if Mode.SyncOUTR then s:='Initiated' else s:='No, why?';
    writeln('Enabled');
		writeln('Reset Output Synchronization Counter - '+s);
		writeln(Format('Number of steps after which synchronization output sygnal occures - %u', [Mode.SyncCount] ));
	end
  else writeln('Disabled');

	writeln('Synchronization input mode:');
	if Mode.SyncINOp then
		writeln('Step motor will move one time to the destination position')
	else
		writeln('Step motor will move multiple times by [destination position]');
	write('Synchronization Output is ');
	if Mode.SyncInvert then
		writeln('INVERTED')
	else
		writeln('NORMAL');
end;

procedure PrintEnState(EnState:TUSMC_EncoderState;up:TUSMC_Parameters);
begin
	writeln('The encoder state is:');
  writeln(Format('- Current Position in microsteps - %.2f', [EnState.ECurPos/up.EncMult] ));
	writeln(Format('- Encoder Position in microsteps - %.2f', [EnState.EncoderPos/up.EncMult] ));
  writeln('');
	writeln(Format('- Current Position in "Half of Encoder Step" - %d', [EnState.ECurPos] ));
	writeln(Format('- Encoder Position in "Half of Encoder Step" - %d', [EnState.EncoderPos] ));
end;

// Function that prints information about device parameters to console
procedure PrintDParameters(Parameters:TUSMC_Parameters);
begin
	writeln('The parameters are:' );
	writeln(Format('Full acceleration time - %.0f ms', [ Parameters.AccelT] ));
	writeln(Format('Full deceleration time - %.0f ms', [Parameters.DecelT] ));
	writeln(Format('Power reduction timeout - %.0f ms', [ Parameters.PTimeout] ) );
	writeln(Format('Button speedup timeout 1 - %.0f ms', [ Parameters.BTimeout1] ) );
	writeln(Format('Button speed after timeout 1 - %.2f steps/s', [ Parameters.BTO1P] ) );
	writeln(Format('Button speedup timeout 2 - %.0f ms', [ Parameters.BTimeout2] ) );
	writeln(Format('Button speed after timeout 2 - %.2f steps/s', [ Parameters.BTO2P] ) );
	writeln(Format('Button speedup timeout 3 - %.0f ms', [ Parameters.BTimeout3] ) );
	writeln(Format('Button speed after timeout 3 - %.2f steps/s', [ Parameters.BTO3P] ) );
	writeln(Format('Button speedup timeout 4 - %.0f ms', [ Parameters.BTimeout4] ) );
	writeln(Format('Button speed after timeout 4 - %.2f steps/s', [ Parameters.BTO4P] ) );
	writeln(Format('Button reset timeout - %.0f ms', [ Parameters.BTimeoutR] ) );
	writeln(Format('Button reset operation speed - %.2f steps/s', [ Parameters.MinP] ) );
	writeln(Format('Backlash operation distance - %d steps', [ Parameters.MaxLoft] ) );
	writeln(Format('Revolution distance - %d steps', [ Parameters.RTDelta] ) );
	writeln(Format('Minimal revolution distance error - %d steps', [ Parameters.RTMinError] ) );
	writeln(Format('Power off temperature - %.2f'+#248+#67, [Parameters.MaxTemp] ) );
	write('Duration of the output synchronization pulse - ');
	if (Parameters.SynOUTP=0) then
		writeln('minimal')
	else
		writeln(Format('%.1f * [Tact Period]', [Parameters.SynOUTP - 0.5]));
	write('Speed of the last phase of the backlash operation - ');
	if(Parameters.LoftPeriod = 0) then
		writeln('normal' )
	else
		writeln(Format('%.2f steps/s', [Parameters.LoftPeriod] ));
	writeln(Format('<Angular Encoder Step> Equals <Angular Step Motor Step>/<%.2f>', [Parameters.EncMult]));
end;

function Menu: integer;
var
	Speed: single;
	DestPos:integer;
  s:string;
	State: TUSMC_State;
	StPrms: TUSMC_StartParameters;
	Prms: TUSMC_Parameters;
	Mode: TUSMC_Mode;
  EnState: TUSMC_EncoderState;
  newCurPos: integer;
begin
  Speed:=2000;

	writeln('Menu:');
	writeln('1 - Get device state');
	writeln('2 - START');
	writeln('3 - STOP');
	writeln('4 - Set Parameters (can be changed only in curret example code)');
	writeln('5 - Set Mode (can be changed only in curret example code)');
	writeln('6 - Set Current Position (can be changed only in curret example code)');

  writeln('7 - Turn Off and Save Current Position to Flash');
  writeln('r - Revert Start Position to 0');
	writeln('8 - Get Encoder State');
	writeln('');
  if SMPower then s:='Off'
  else s:='On';
	writeln(Format('p - Turn %s Power',[s]));
	writeln('');
	writeln('9 - Select other device');
	writeln('0 - Exit');
	writeln('Choose:');

  readln(s);
  if s='' then s:=' ';
  case s[1] of
  	'1':
    begin
		  if StandaClass.USMC_GetState(Dev, State)>0 then
  		begin
	  		PrintError();
		  	result:=0;
        exit;
  		end;
  		Cls;
	  	PrintDState(State);
		  writeln('');
    end;
	  '2':
    begin
	  	if StandaClass.USMC_GetStartParameters(Dev, StPrms)>0 then
		  begin
  			PrintError();
	  		result:=0;
        exit;
		  end;
  		Cls;
	  	ScanDStartParameters(DestPos, Speed, StPrms);
		  if StandaClass.USMC_Start(Dev, DestPos, Speed, StPrms) >0 then
  		begin
	  		PrintError();
		  	result:=0;
        exit;
  		end;
	  	Cls;
		  PrintDStartParameters(DestPos, Speed, StPrms);
  		writeln('');
    end;
  	'3':
    begin
  		if StandaClass.USMC_Stop(Dev)>0 then
	  	begin
		  	PrintError();
			  result:=0;
        exit;
	  	end;
      Cls;
  	end;
    '4':
  	begin
    	if StandaClass.USMC_GetParameters(Dev, Prms)>0 then
		  begin
			  PrintError();
  			result:=0;
        exit;
		  end;
  		// Set anything you want here
	  	Prms.MaxTemp:= 70.0;
		  //Prms.LoftPeriod:= 0.0;
  		Prms.BTimeout1:= 500.0;
	  	Prms.BTimeout2:= 500.0;
		  Prms.BTimeout3:= 500.0;
  		Prms.BTimeout4:= 500.0;
	  	Prms.BTO1P:= 200.0;
		  Prms.BTO2P:= 300.0;
  		Prms.BTO3P:= 400.0;
	  	Prms.BTO4P:= 500.0;
    	Prms.AccelT:= 200.0;
    	Prms.DecelT:= 200.0;
    	Prms.BTimeoutR:= 500.0;
    	Prms.LoftPeriod:= 500.0;
    	Prms.RTDelta:= 200;
    	Prms.RTMinError:= 15;
    	Prms.EncMult:= 2.5;
    	Prms.MaxLoft:= 32;
    	Prms.PTimeout:= 100.0;
    	Prms.SynOUTP:= 1;

  		if StandaClass.USMC_SetParameters( Dev, Prms )>0 then
	  	begin
		  	PrintError();
  		  result:=0;
        exit;
		  end;

      if StandaClass.USMC_SaveParametersToFlash( Dev )>0 then
	  	begin
		  	PrintError();
  		  result:=0;
        exit;
		  end;

  		Cls;
	  	PrintDParameters( Prms );
      writeln('');
  		writeln('These Parameters are Saved to Flash');
  		writeln('Press Enter to exit');
	  	readln(s);
		  Cls;
  	end;
	  '5':
    begin
		  if StandaClass.USMC_GetMode(Dev, Mode)>0 then
  		begin
	  		PrintError;
		  	result:=0;
        exit;
  		end;

	  	// Set anything you want here
  	 	Mode.SyncInvert:= not Mode.SyncInvert;
      Mode.EncoderEn:= TRUE;
    	Mode.RotTrOp:= FALSE;
    	Mode.ResetRT:= TRUE;
	  	// Set anything you want here

		  if StandaClass.USMC_SetMode(Dev, Mode)>0 then
  		begin
	  		PrintError;
		  	result:=0;
        exit;
  		end;
	  	Cls;
		  PrintDMode(Mode);
      writeln('');
	  	writeln('Press Enter to exit');
		  readln(s);
  		Cls;
	  end;
    //Set_Current_Position
    '6':
    begin
	    newCurPos:= 1000;
      if StandaClass.USMC_SetCurrentPosition(Dev, newCurPos)>0 then
    	begin
	  		PrintError;
		  	result:=0;
        exit;
  		end;
      Cls;
	    writeln(Format('SetCurrentPosition executed with argument %d',[newCurPos]));
	    writeln('Press Enter to exit');
		  readln(s);
  		Cls;
    end;
    '7':
    begin
      //Turn_Off_and_Save_Current_Position_to_Flash
    	// Initialize structures (in case this function runs first)
	    if  StandaClass.USMC_GetParameters(Dev, Prms)>0 then
    	begin
	  		PrintError;
		  	result:=0;
        exit;
  		end;
	    if StandaClass.USMC_GetMode(Dev, Mode)>0 then
    	begin
	  		PrintError;
		  	result:=0;
        exit;
  		end;
	    // Go to Full Step (automaticaly), then Turn Off
	    Mode.ResetD:= TRUE;
	    if StandaClass.USMC_SetMode(Dev, Mode)>0 then
    	begin
	  		PrintError;
		  	result:=0;
        exit;
  		end;
	    // Wait until Previous Comand is Done
	    repeat
	    	Sleep(50);
		    if StandaClass.USMC_GetState(Dev, State)>0 then
       	begin
	    		PrintError;
		    	result:=0;
          exit;
  	  	end;
	    until State.Power<>TRUE;
	    // Remember CurPos in Parameters Only While State.Power - FALSE
	    Prms.StartPos:= State.CurPos;
  	  if StandaClass.USMC_SetParameters( Dev, Prms )>0 then
    	begin
	  		PrintError;
		  	result:=0;
        exit;
  		end;
	    // Then of Course You Need to SaveToFlash
	    if StandaClass.USMC_SaveParametersToFlash( Dev )>0 then
    	begin
	  		PrintError;
		  	result:=0;
        exit;
  		end;
    	// Now You Can Unplug ME
      Cls;
	    writeln(Format('The Position "%d" is Saved to Flash',[Prms.StartPos]));
      writeln('When Controller is Powered Up Next Time');
      writeln('It Will Start From This Position');
	    writeln('Press Enter to exit');
		  readln(s);
  		Cls;
    end;
   	// Initialize structures (in case this function runs first)
    'r':
    begin
	    if StandaClass.USMC_GetParameters(Dev, Prms)>0 then
    	begin
	  		PrintError;
		  	result:=0;
        exit;
  		end;
	    Prms.StartPos:= 0;
	    if StandaClass.USMC_SetParameters( Dev, Prms )>0 then
    	begin
	  		PrintError;
		  	result:=0;
        exit;
  		end;
	    // Then of Course You Need to SaveToFlash
	    if StandaClass.USMC_SaveParametersToFlash( Dev )>0 then
    	begin
	  		PrintError;
		  	result:=0;
        exit;
  		end;
      Cls;
      writeln('Start Position is Reset to 0');
	    writeln('Press Enter to exit');
		  readln(s);
  		Cls;
    end;
    '8':
    begin
    	if StandaClass.USMC_GetEncoderState(Dev, EnState)>0 then
    	begin
	  		PrintError;
		  	result:=0;
        exit;
  		end;
    	if StandaClass.USMC_GetParameters(Dev, Prms)>0 then
    	begin
	  		PrintError;
		  	result:=0;
        exit;
  		end;
      Cls;
    	PrintEnState(EnState, Prms);
      writeln('');
	    writeln('Press Enter to exit');
		  readln(s);
  		Cls;
    end;
    'p','P':
    begin
    	if StandaClass.USMC_GetMode(Dev, Mode)>0 then
    	begin
	  		PrintError;
		  	result:=0;
        exit;
  		end;

	    SMPower:= not SMPower;
	    Mode.ResetD:= not SMPower;

	    if StandaClass.USMC_SetMode(Dev, Mode)>0 then
    	begin
	  		PrintError;
		  	result:=0;
        exit;
  		end;
      Cls;
    	if Mode.ResetD then writeln('Now, Power is Off')
      else writeln('Now, Power is On');
      writeln('');
	    writeln('Press Enter to exit');
		  readln(s);
  		Cls;
    end;
    '9':
    begin
	  	result:=1;
      exit;
    end;
  	'0':
    begin
		  writeln('');
  		result:=0;
      exit;
    end;
  	else
	  	Cls;
  end;
	result:=2;
end;

function SelectMenu: integer;
var
	ret: integer;
  s: string;
begin
  Dev:= High(Longword);
	while Dev>DVS.NOD do
  begin
    Cls;
    PrintDevices( DVS );
    writeln('');
		writeln(#9+'0'+#9+'Exit');
		writeln(#9+'x'+#9+'ReInitialize');
		writeln(#9+'xx'+#9+'Close Driver Window and Exit');
    writeln('');
		write('Select:');
    readln(s);
		if s='x' then
		begin
			//// Perform "Refresh" of Driver
			if StandaClass.USMC_Init( DVS )>0 then
			begin
				PrintError();
				result:=0;
			end;
    end
		else if s='xx' then
	  begin
			//// Close the MicroSMC.exe process
			if StandaClass.USMC_Close()>0 then
			begin
				PrintError();
				result:=0;
			end;
      result:=0;
			exit;
		end;
    Dev:=StrToIntDef(s,High(Longword));
    if Dev=0 then
     begin
       result:=0;
       exit;
     end;
   end;

	dec(Dev);
	Cls;
 	repeat
		ret:=Menu;
	until ret<>2;
	result:=ret;
end;

procedure D_Exit(s:string);
var
  ss:string;
begin
  writeln('');
  writeln(s);
  writeln('Press Enter to exit');
  readln(ss);
end;

begin
  Cls;
  StandaClass:=TStandaClass.Create;
  if StandaClass = nil then
  begin
    D_Exit('Error: Can`t create object with DLL function');
    exit;
  end;
  if not StandaClass.bDllLoadOK then
  begin
    StandaClass.Destroy;
    D_Exit('Error: Can`t load DLL');
    exit;
  end;
  if(StandaClass.USMC_Init( DVS ) > 0 ) then
  begin
    PrintError();
    StandaClass.Destroy;
    D_Exit('');
    exit;
  end;
  while(SelectMenu>0) do ;
{***************************** Memory free ***************}
// when DVS.Serial is Pointer we comment this string
// We add this string when DVS.Serial is array of PChar
//  Finalize(DVS);
{***************************** Memory free ***************}
  StandaClass.Destroy;
  D_Exit('');
end.
